/* ***************************************************************** 
    MESQUITE -- The Mesh Quality Improvement Toolkit

    Copyright 2004 Sandia Corporation and Argonne National
    Laboratory.  Under the terms of Contract DE-AC04-94AL85000 
    with Sandia Corporation, the U.S. Government retains certain 
    rights in this software.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License 
    (lgpl.txt) along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    diachin2@llnl.gov, djmelan@sandia.gov, mbrewer@sandia.gov, 
    pknupp@sandia.gov, tleurent@mcs.anl.gov, tmunson@mcs.anl.gov      
   
  ***************************************************************** */
// -*- Mode : c++; tab-width: 3; c-tab-always-indent: t; indent-tabs-mode: nil; c-basic-offset: 3 -*-

/*! \file VolSumLengthQM.hpp

Header file for the Mesquite::VolSumLengthQM class

\author Shankar Prasad Sastry
\date   9th July 2008
 */

#ifndef VolSumLengthQM_hpp
#define VolSumLengthQM_hpp

#include <vector>
#include "Mesquite.hpp"
#include "MsqError.hpp"
#include "ElementQM.hpp"
#include "AveragingQM.hpp"
#include "Vector3D.hpp"
#include "Matrix3D.hpp"
#include "Exponent.hpp"
#include "Mesquite_all_headers.hpp"

using namespace std;

namespace MESQUITE_NS
{
   class MsqMeshEntity;
   class PatchData;
   class MsqError;

   /*! \class VolSumLengthQM
     \brief Computes the mean ratio quality metric
     of given element.
     
     The metric does not use the sample point functionality or the
     compute_weighted_jacobian.  It evaluates the metric at
     the element vertices, and uses the anisotropic ideal element.
     It does require a feasible region, and the metric needs
     to be minimiseds.
   */
   class VolSumLengthQM : public ElementQM, public AveragingQM
   {
   public:
 
     //MESQUITE_EXPORT VolSumLengthQM(MsqError &err, double pow=1.0);
     MESQUITE_EXPORT VolSumLengthQM()
	  : AveragingQM(QualityMetric::LINEAR)
	{
	}
     
     //! virtual destructor ensures use of polymorphism during destruction
     MESQUITE_EXPORT virtual ~VolSumLengthQM(){
	}
     //virtual ~VolSumLengthQM();

      //! 1 if metric should be minimized, -1 if metric should be maximized.
     virtual int get_negate_flag() const
	{ return -1; }
     virtual msq_std::string get_name() const
	{ return "Volume Length Ratio"; }

     virtual
     bool evaluate( PatchData& pd, 
                    size_t handle, 
                    double& value, 
                    MsqError& err )

{
	  vector<Vector3D> vert;
	  Vector3D temp_vec[6], temp_v;
	  double vol, fval, fval_temp[6];
	
	  const MsqMeshEntity* e = &pd.element_by_index(handle);
	  EntityTopology topo = e->get_element_type();

	  
	  switch(topo) {
	  case TRIANGLE:

	    /*mCoords[0] = vertices[v_i[0]];
	    mCoords[1] = vertices[v_i[1]];
	    mCoords[2] = vertices[v_i[2]];
            tcoord.clear();
	    for(int i=0; i<3; i++)
		coords.push_back(tcoord);
	    for(int i=0; i<3; i++)
		for (int j=0; j<3; j++)
			coords[i].push_back(mCoords[i][j]);*/
		
	    //m = find_quality_tri(coords);
	    /*if (value<0)
		return false;*/
	    return true;
	    break;

	  case TETRAHEDRON:
		  if (value==1e6)
		  {
			bool ret;
			double mm = value;
			ret = multi_evaluate(pd, handle, mm, err, tt);
			value=mm;
			return ret;
		  }

  	    	pd.get_element_vertex_coordinates(handle, vert, err);  MSQ_ERRZERO(err);
	     	vol=(vert[1]-vert[0])%((vert[2]-vert[0])*(vert[3]-vert[0]))/6.0;
		//vol = fabs(vol);
			//sum of edges squared


			temp_v=vert[1]-vert[0];
			fval=temp_v.length_squared();
			temp_v=vert[2]-vert[0];
			fval+=temp_v.length_squared();
			temp_v=vert[3]-vert[0];
			fval+=temp_v.length_squared();
			temp_v=vert[2]-vert[1];
			fval+=temp_v.length_squared();
			temp_v=vert[3]-vert[1];
			fval+=temp_v.length_squared();
			temp_v=vert[3]-vert[2];
			fval+=temp_v.length_squared();
			//average sum of edges squared
			fval/=6.0;
			fval*=sqrt(fval);

			//ESCOBAR QUALITY ONLY
			//vol = 0.5*(vol + sqrt(vol*vol + 0.002*0.002));		

			fval = (12/sqrt(2))*vol/fval;	
			//SIGMOID
			vol*=10;

			//min length
			/*temp_vec[0]=(vert[1]-vert[0]);
			temp_vec[1]=(vert[2]-vert[0]);
			temp_vec[2]=(vert[3]-vert[0]);
			temp_vec[3]=(vert[2]-vert[1]);
			temp_vec[4]=(vert[3]-vert[1]);
			temp_vec[5]=(vert[3]-vert[2]);
			for(int i=0; i<6; i++)
			{
				fval_temp[i] = temp_vec[i].length_squared();
				fval_temp[i] *= sqrt(fval_temp[i]);
				fval_temp[i] = (12/sqrt(2))*vol/fval_temp[i];
			}
			fval = fval_temp[0];
			for(int i=1; i<6; i++)
			{
				if(fval>fval_temp[i])
					fval=fval_temp[i];
			}*/



		//ESCOBAR
		//value=fval;
		//value=1.0/fval;

		//SIGMOID
		value  = fval * (1.0/(1+exp(-10000000*fval)));
		value  += vol * (1.0/(1+exp(10000000*vol)));
		/*if(vol>fval)
			value = fval;
		else
			value = vol;*/
		//if (value<2e-6)	
			//printf("value %.10lf", value);
	    if (value<tt)
		{
			//printf("here oh boy! %lf %lf\n",value, tt);
			return false;
		}
	    return true;
	    break;
	    
	  case POLYGON:
	  case QUADRILATERAL:
	  case POLYHEDRON:
	  case HEXAHEDRON:
	  case PRISM:
	  case SEPTAHEDRON:
	  case MIXED:
	  default:
	    MSQ_SETERR(err)(MsqError::UNSUPPORTED_ELEMENT,
			    "Element type (%d) not supported in here!",(int)topo);
	    return false;
	  } // end switch over element type
	  return true;
	}





    private:
      // arrays used in Hessian computations 
      // We allocate them here, so that one allocation only is done.
      // This gives a big computation speed increase.
      Vector3D mCoords[4]; // Vertex coordinates for the (decomposed) elements
      Vector3D mGradients[32]; // Gradient of metric with respect to the coords
      Matrix3D mHessians[80]; // Hessian of metric with respect to the coords
      double   mMetrics[8]; // Metric values for the (decomposed) elements
      bool multi_evaluate( PatchData& pd, 
					     size_t handle, 
					     double& m, 
					     MsqError& err,
					     double& tvalue)
{
		vector<Vector3D> vert;
	  	Vector3D temp_vec, tvec[6] ;
	  	double vol, fval, tval[6];

		pd.get_element_vertex_coordinates(handle, vert, err);  MSQ_ERRZERO(err);
	     	vol=(vert[1]-vert[0])%((vert[2]-vert[0])*(vert[3]-vert[0]))/6.0;
		
			// sum of squares
			temp_vec=vert[1]-vert[0];
			fval=temp_vec.length_squared();
			temp_vec=vert[2]-vert[0];
			fval+=temp_vec.length_squared();
			temp_vec=vert[3]-vert[0];
			fval+=temp_vec.length_squared();
			temp_vec=vert[2]-vert[1];
			fval+=temp_vec.length_squared();
			temp_vec=vert[3]-vert[1];
			fval+=temp_vec.length_squared();
			temp_vec=vert[3]-vert[2];
			fval+=temp_vec.length_squared();
			//average sum of edges squared
			fval/=6.0;
			fval*=sqrt(fval);
			//normalize to equil. and div by area


			//ESCOBAR
			//vol = 0.5*(vol + sqrt(vol*vol + 0.002*0.002));
			//double value=(12/sqrt(2))*vol/fval;
			
			//FOR THE SIGMOID QUALITY
			fval=(12/sqrt(2))*vol/fval;
			vol *=10;
			double value  = fval * (1.0/(1+exp(-10000000*fval)));
			       value  += vol * (1.0/(1+exp(10000000*vol)));
			if (value < tvalue)
			{
				m = 1e10;
				//printf("here we go %lf %lf %lf\n", fval, vol, tvalue);
				return false;
			}
			m = log(value - tvalue); 







			/*if (fval < tvalue || vol < tvalue)
			{
				m = 1e10;
				//printf("here we go %lf %lf %lf\n", fval, vol, tvalue);
				return false;
			}
			m = log(fval - tvalue) + log(vol - tvalue);*/

			//min length
			/*tvec[0]=(vert[1]-vert[0]);
			tvec[1]=(vert[2]-vert[0]);
			tvec[2]=(vert[3]-vert[0]);
			tvec[3]=(vert[2]-vert[1]);
			tvec[4]=(vert[3]-vert[1]);
			tvec[5]=(vert[3]-vert[2]);
			m=0;	
			fval = 1e10;
			for(int i=0; i<6; i++)
			{
				tval[i] = tvec[i].length_squared();
				tval[i] *= sqrt(tval[i]);
				tval[i] = (12/sqrt(2))*vol/tval[i];
				
				if(tval[i]<tvalue)
				{
					//printf("oh boy! %.10lf %.10lf\n",tval[i], tvalue);
					m = 1e10; return false;
				}
			}

			for(int i=0; i<6; i++)
				m+=log(tval[i] - tvalue);*/


			return true;
	}


   };



} //namespace


#endif // VolSumLengthQM_hpp
